<?php
/*--------------------------------------------------------------
   Database.php 2021-07-12
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Data;

use Gambio\Admin\Modules\Statistics\App\Overview\Factory\Connection;
use RuntimeException;
use SleekDB\Store;

class Database
{
    private const DATABASE_DIRECTORY = __DIR__ . "/Storage";
    
    /**
     * @var Store
     */
    private $connection;
    
    
    /**
     * Constructor.
     */
    public function __construct(Connection $connectionFactory)
    {
        // @codeCoverageIgnoreStart
        if (!file_exists(self::DATABASE_DIRECTORY)
            && !mkdir($concurrentDirectory = self::DATABASE_DIRECTORY)
            && !is_dir($concurrentDirectory)) {
            throw new RuntimeException('The statistics storage could not be created. Please create it manually.');
        }
        
        if (!is_writable(self::DATABASE_DIRECTORY)) {
            throw new RuntimeException('The statistics storage is not writable. Please adjust it manually.');
        }
        // @codeCoverageIgnoreEnd
        
        $this->connection = $connectionFactory->createConnection(self::DATABASE_DIRECTORY);
    }
    
    
    /**
     * Update or insert data.
     */
    public function updateOrInsert(array $data): void
    {
        $this->connection->updateOrInsert($data);
    }
    
    
    /**
     * Update by ID.
     */
    public function updateById(int $id, array $data): void
    {
        $this->connection->updateById($id, $data);
    }
    
    
    /**
     * Delete by ID.
     */
    public function deleteById(int $id): void
    {
        $this->connection->deleteById($id);
    }
    
    
    /**
     * Find all.
     */
    public function findAll(): array
    {
        return $this->connection->findAll();
    }
    
    
    /**
     * Find by ID.
     */
    public function findById(int $id): array
    {
        return $this->connection->findById($id);
    }
}